IF EXISTS (select * from sysobjects where name like '%T_Delete_Servidor%')
DROP TRIGGER T_Delete_Servidor
go

CREATE TRIGGER T_Delete_Servidor
ON  Servidor
FOR DELETE
AS
	DECLARE @IdZona DECIMAL(20,0);

	DECLARE Elems_Cursor333 CURSOR FOR
	SELECT IsNull(IdZona,-1) FROM DELETED;
	OPEN Elems_Cursor333

	FETCH NEXT FROM Elems_Cursor333 INTO @IdZona
	WHILE @@FETCH_STATUS = 0
	BEGIN	

		IF @IdZona != -1
		BEGIN
			--En caso de que el servidor tenga zona vinculada, hacemos la proteccin que la zona sea zona final
			IF (SELECT COUNT(*) FROM Zona WHERE Zona.IdZonaPadre=@IdZona) = 0
			BEGIN
				IF (SELECT COUNT(*) FROM Servidor WHERE IsNull(IdZona,-1)=@IdZona) > 0
				BEGIN
					UPDATE Zona SET TieneServidores=1 WHERE Zona.IdZona=@IdZona
				END
				ELSE
				BEGIN
					UPDATE Zona SET TieneServidores=0 WHERE Zona.IdZona=@IdZona
				END
			END
		END

		PRINT 'Ejecucion trigger T_Delete_Servidor.'
		
	FETCH NEXT FROM Elems_Cursor333 INTO @IdZona
	END

	CLOSE Elems_Cursor333
	DEALLOCATE Elems_Cursor333

		---------- WebManager ----------
	DECLARE @CodigoServidor NVARCHAR(30);
	DECLARE Elems_Cursor22222 CURSOR FOR
	SELECT CodigoServidor FROM DELETED;
	OPEN Elems_Cursor22222
	
	FETCH NEXT FROM Elems_Cursor22222 INTO @CodigoServidor
	WHILE @@FETCH_STATUS = 0
	BEGIN	
	
		PRINT 'Borramos tablas WM_CodigoServidor y WM_ServidorCliente'

		DELETE FROM WM_ServidorCliente WHERE CodigoServidor=@CodigoServidor
		DELETE FROM WM_CodigoServidor WHERE CodigoServidor=@CodigoServidor
				
		PRINT 'Fin borramos tablas WM_CodigoServidor y WM_ServidorCliente'

	FETCH NEXT FROM Elems_Cursor22222 INTO @CodigoServidor
	END
	
	CLOSE Elems_Cursor22222
	DEALLOCATE Elems_Cursor22222

	---------- Fin WebManager ----------
	
GO
ALTER TABLE Servidor ENABLE TRIGGER T_Delete_Servidor
GO
